IF NOT EXISTS (
    SELECT i.index_id
    FROM sys.indexes i
    JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
    JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
    WHERE i.object_id = OBJECT_ID('dbo.EST_NUM_SEQ_TABELA') 
        AND i.type_desc = 'NONCLUSTERED'
        AND (
            (c.name = 'CD_EMP' AND ic.is_included_column = 0)
            OR (c.name = 'TABELA' AND ic.is_included_column = 0)
            OR (c.name = 'CHAVE' AND ic.is_included_column = 0)
			OR (c.name = 'AGRUPAMENTO' AND ic.is_included_column = 0)
        )
		AND EXISTS (SELECT 1
					FROM sys.index_columns IC2
					WHERE iC2.object_id = ic.object_id AND iC2.index_id = ic.index_id
					GROUP BY iC2.object_id, iC2.index_id
					HAVING COUNT(1) = 4)
    GROUP BY i.object_id, i.index_id
)
BEGIN
    CREATE NONCLUSTERED INDEX [IX_EST_NUM_SEQ_TABELA_CD_EMP_TABELA_CHAVE_AGRUPAMENTO] ON [dbo].[EST_NUM_SEQ_TABELA]
	(
		[CD_EMP] ASC,
		[TABELA] ASC,
		[CHAVE] ASC,
		[AGRUPAMENTO] ASC
	);
END


